/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.udf;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.util.LogoXMLProperties;
import DE.siemens.ad.logo.util.UDFXMLHandler;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.udf.GuidVersionMgr;
import DE.siemens.ad.udf.UDFBlock;
import DE.siemens.ad.udf.UDFLibrary;
import DE.siemens.ad.udf.UDFLmaHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.dom4j.Document;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDFFactory {
    private static UDFFactory instance = new UDFFactory();
    private Map<String, UDFBlock> createdUDFMap = new HashMap<String, UDFBlock>();
    private Map<String, UDFBlock> udfPropsMap = new HashMap<String, UDFBlock>();
    private List<String> addFileList = new ArrayList<String>();
    private List<String> removeFileList = new ArrayList<String>();

    private UDFFactory() {
    }

    public static UDFFactory instance() {
        return instance;
    }

    public void loadUDFProps() {
        LogoXMLProperties logoUDFLibprop = LogoXMLProperties.getInstance();
        List<String> paths = logoUDFLibprop.getLibraryProperties(false);
        if (paths == null) {
            return;
        }
        for (String path : paths) {
            this.parseUDFProps(path);
        }
    }

    public void parseUDFProps(String filePath) {
        File file = new File(filePath);
        if (!file.exists() || file.isFile() && !filePath.toLowerCase().endsWith(".lma")) {
            return;
        }
        if (file.isDirectory()) {
            for (File subFile : file.listFiles()) {
                this.parseUDFProps(subFile.getAbsolutePath());
            }
        } else {
            UDFLmaHandler handler = new UDFLmaHandler();
            try {
                SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                parser.parse(file, (DefaultHandler)handler);
            }
            catch (UDFLmaHandler.UDFSAXException e) {
                UDFBlock blk = new UDFBlock();
                blk.setGuidManager(handler.getGuidVersionMgr());
                blk.setValidity(handler.getValidity());
                blk.setIdentifier(handler.getIdentifier());
                this.udfPropsMap.put(filePath, blk);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public UDFBlock getUDFBlock(WiringDiagram wd, String udfFilePath, boolean allocateNew) {
        UDFBlock block = null;
        if (this.createdUDFMap.containsKey(udfFilePath)) {
            block = (UDFBlock)this.createdUDFMap.get(udfFilePath).clone();
            block.setWiringDiagram(wd);
        } else {
            Document document = UDFXMLHandler.loadDocument(new File(udfFilePath).getAbsolutePath());
            UDFBlock udfBlock = wd.getHardware().compileUDFBlockFromXml(document);
            udfBlock.setWiringDiagram(wd);
            if (udfBlock == null) {
                return null;
            }
            this.createdUDFMap.put(udfFilePath, udfBlock);
            block = (UDFBlock)udfBlock.clone();
        }
        block.initBlockNumber(false, allocateNew);
        return block;
    }

    public UDFBlock getUDFBlock(WiringDiagram wd, long guid) {
        String udfpath = this.getUDFFilePath(guid);
        UDFBlock block = null;
        if (this.createdUDFMap.containsKey(udfpath)) {
            block = (UDFBlock)this.createdUDFMap.get(udfpath).clone();
            block.initBlockNumber(true, true);
        } else {
            block = this.getUDFBlock(wd, udfpath, true);
        }
        return block;
    }

    public long getLatestGuid(long oldGuid) {
        Iterator<String> udfPaths = this.udfPropsMap.keySet().iterator();
        while (udfPaths.hasNext()) {
            GuidVersionMgr guidMgr = this.udfPropsMap.get(udfPaths.next()).getGuidManager();
            if (!guidMgr.containsGuid(oldGuid)) continue;
            return guidMgr.getGuid();
        }
        return 0L;
    }

    public String getUDFFilePath(long guid) {
        for (String path : this.udfPropsMap.keySet()) {
            GuidVersionMgr guidMgr = this.udfPropsMap.get(path).getGuidManager();
            if (!guidMgr.containsGuid(guid)) continue;
            return path;
        }
        return null;
    }

    public void udfLibraryChanged() {
        for (String path : this.removeFileList) {
            this.removeCreatedUDF(path);
            this.removeUDFProps(path);
        }
        for (String path : this.addFileList) {
            this.parseUDFProps(path);
        }
        for (LogoDrawingView view : Application.getInstance().getMdiManager().getViews()) {
            Hardware hardware = ((LogoDrawing)view.drawing()).getWiringDiagram().getHardware();
            if (hardware == null || !hardware.supports("UDF")) continue;
            ((LogoComfort)view.getEditor()).updateUDFLibraryNode();
            ((LogoDrawing)view.drawing()).updateUDFBlockState(false);
        }
    }

    public void updateUDFRelated(String udfPath, String newIdentifier, GuidVersionMgr guidMgr, int validity) {
        this.removeCreatedUDF(udfPath);
        this.removeUDFProps(udfPath);
        UDFBlock udfBlkProp = new UDFBlock();
        udfBlkProp.setGuidManager(guidMgr);
        udfBlkProp.setValidity(validity);
        udfBlkProp.setIdentifier(newIdentifier);
        this.udfPropsMap.put(udfPath, udfBlkProp);
        for (LogoDrawingView view : Application.getInstance().getMdiManager().getViews()) {
            Hardware hardware = ((LogoDrawing)view.drawing()).getWiringDiagram().getHardware();
            if (hardware == null || !hardware.supports("UDF")) continue;
            ((LogoComfort)view.getEditor()).updateUDFLibraryNode();
            ((LogoDrawing)view.drawing()).updateUDFBlockState(false);
        }
    }

    public UDFBlock getUDFBlockProp(String filePath) {
        if (!this.udfPropsMap.containsKey(filePath)) {
            this.parseUDFProps(filePath);
        }
        return this.udfPropsMap.get(filePath);
    }

    public void removeCreatedUDF(String filePath) {
        if (!UDFLibrary.isUDFSelected(filePath)) {
            return;
        }
        if (new File(filePath).isDirectory()) {
            for (File eachFile : new File(filePath).listFiles()) {
                this.removeCreatedUDF(eachFile.getAbsolutePath());
            }
        } else if (this.createdUDFMap.containsKey(filePath)) {
            this.createdUDFMap.remove(filePath);
        }
    }

    public void removeUDFProps(String filePath) {
        if (!UDFLibrary.isUDFSelected(filePath)) {
            return;
        }
        if (new File(filePath).isDirectory()) {
            for (File eachFile : new File(filePath).listFiles()) {
                this.removeUDFProps(eachFile.getAbsolutePath());
            }
        } else if (this.udfPropsMap.containsKey(filePath)) {
            this.udfPropsMap.remove(filePath);
        }
    }

    public Map<String, UDFBlock> getUDFPropMap() {
        return this.udfPropsMap;
    }

    public void addAddFile(String filePath) {
        if (this.removeFileList.contains(filePath)) {
            this.removeFileList.remove(filePath);
        }
        this.addFileList.add(filePath);
    }

    public void addRemoveFile(String filePath) {
        if (this.addFileList.contains(filePath)) {
            this.addFileList.remove(filePath);
        }
        this.removeFileList.add(filePath);
    }

    public int getUDFBlockState(long guid) {
        for (String udfpath : this.udfPropsMap.keySet()) {
            GuidVersionMgr guidMgr = this.udfPropsMap.get(udfpath).getGuidManager();
            if (guidMgr.getGuid() == guid && new File(udfpath).exists()) {
                return 0;
            }
            if (!guidMgr.containsGuid(guid) || !new File(udfpath).exists()) continue;
            return 1;
        }
        return 2;
    }
}

